#!/bin/bash
# Script d'installation des dépendances pour qrsend sur Debian 12

# Mettre à jour la liste des paquets et installer PHP et les extensions requises
sudo apt-get update
sudo apt-get install -y php php-cli php-xml php-mbstring php-curl php-zip unzip qrencode

# Installer Composer s'il n'est pas présent
if ! command -v composer &> /dev/null; then
    echo "Composer n'est pas installé. Installation de Composer..."
    php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
    php composer-setup.php --install-dir=/usr/local/bin --filename=composer
    rm composer-setup.php
fi

# Se positionner dans le répertoire du projet
cd /var/www/darktuche.xyz/qrsend/

# Installer les dépendances via Composer
composer require phpmailer/phpmailer phpoffice/phpspreadsheet

echo "Installation terminée. Veuillez vérifier que les fichiers config.json et email_templates.json existent et sont correctement configurés."
